#include <struct.h>
#include <3dengine.h>
#include "pagecol.h"
#include "../resource.h"

BEGIN_MESSAGE_MAP(CColorPage, CPropertyPage)
  ON_LBN_SELCHANGE(IDC_COLORLIST, OnSelChange)
  ON_LBN_SELCHANGE(IDC_COLORLISTSAMPLES, OnColChange)
  
  ON_BN_CLICKED(IDC_COLORCOLORBUTTON, OnChooseColor)
  ON_BN_CLICKED(IDC_COLORFONTBUTTON, OnChooseFont)
END_MESSAGE_MAP()


CColorPage::CColorPage()
{
  CPropertyPage();
  NumColors = 24;
  LOGPEN    lPen;
  LOGBRUSH  lBrush;
  ColorsDesc = new sColDesc[NumColors];

  strcpy(ColorsDesc[0].Name, "Mesh: Default lines");
  Global.PenThinBlack->GetLogPen(&lPen); ColorsDesc[0].color = lPen.lopnColor;
  strcpy(ColorsDesc[1].Name, "Mesh: Active lines");
  Global.PenThinBlue->GetLogPen(&lPen); ColorsDesc[1].color = lPen.lopnColor;
  strcpy(ColorsDesc[2].Name, "Mesh: Normals");
  Global.PenThinGreen->GetLogPen(&lPen); ColorsDesc[2].color = lPen.lopnColor;
  strcpy(ColorsDesc[3].Name, "Mesh: Selected lines");
  Global.PenThinDarkRed->GetLogPen(&lPen); ColorsDesc[3].color = lPen.lopnColor;
  strcpy(ColorsDesc[4].Name, "Mesh: Active + Selected lines");
  Global.PenThinRed->GetLogPen(&lPen); ColorsDesc[4].color = lPen.lopnColor;
  strcpy(ColorsDesc[5].Name, "Mesh: Disabled lines");
  Global.PenThinGray->GetLogPen(&lPen); ColorsDesc[5].color = lPen.lopnColor;
  strcpy(ColorsDesc[6].Name, "Dots: Vertices and faces dots");
  ColorsDesc[6].color = Global.ColDots;

  strcpy(ColorsDesc[7].Name, "Inactive Views border");
  Global.PenThinWhite->GetLogPen(&lPen); ColorsDesc[7].color = lPen.lopnColor;
  strcpy(ColorsDesc[8].Name, "Dots line");
  Global.PenThinBlueCreate->GetLogPen(&lPen); ColorsDesc[8].color = lPen.lopnColor;
  strcpy(ColorsDesc[9].Name, "MenuBar: Highlight");
  Global.MenuHighlightPen->GetLogPen(&lPen); ColorsDesc[9].color = lPen.lopnColor;
  strcpy(ColorsDesc[10].Name, "MenuBar: Shadow");
  Global.MenuShadowPen->GetLogPen(&lPen); ColorsDesc[10].color = lPen.lopnColor;

  strcpy(ColorsDesc[11].Name, "MenuBar: Foreground");
  Global.MenuForegroundBrush->GetLogBrush(&lBrush); ColorsDesc[11].color = lBrush.lbColor;
  strcpy(ColorsDesc[12].Name, "MenuBar: Foreground (if active)");
  Global.MenuActiveForegroundBrush->GetLogBrush(&lBrush); ColorsDesc[12].color = lBrush.lbColor;
  strcpy(ColorsDesc[13].Name, "MenuBar: Text: Color");
  ColorsDesc[13].color = Global.MenuCaptionColor;
  strcpy(ColorsDesc[14].Name, "MenuBar: Text: Color (if active)");
  ColorsDesc[14].color = Global.MenuActiveColor;

  strcpy(ColorsDesc[15].Name, "Views: Background");
  Global.BackgroundBrush->GetLogBrush(&lBrush); ColorsDesc[15].color = lBrush.lbColor;
  strcpy(ColorsDesc[16].Name, "Views: Grid: Normal");
  Global.GridNormalPen->GetLogPen(&lPen); ColorsDesc[16].color = lPen.lopnColor;
  strcpy(ColorsDesc[17].Name, "Views: Grid: Tenths");
  Global.GridTenthsPen->GetLogPen(&lPen); ColorsDesc[17].color = lPen.lopnColor;
  strcpy(ColorsDesc[18].Name, "Views: Grid: Axis");
  Global.GridAxisPen->GetLogPen(&lPen); ColorsDesc[18].color = lPen.lopnColor;
  strcpy(ColorsDesc[19].Name, "Views: Caption Color (inactive)");
  ColorsDesc[19].color = Global.ViewsCaptionColor;
  strcpy(ColorsDesc[20].Name, "Views: Caption Color (active)");
  ColorsDesc[20].color = Global.ViewsActiveCaptionColor;

  //fonts;
  LOGFONT* fMenuInact = new LOGFONT;
  LOGFONT* fMenuAct = new LOGFONT;
  LOGFONT* fViews = new LOGFONT;

  Global.MenuCaptionFont->GetLogFont(fMenuInact);
  Global.MenuActiveCaptionFont->GetLogFont(fMenuAct);
  Global.ViewsCaptionFont->GetLogFont(fViews);

  strcpy(ColorsDesc[21].Name, "MenuBar: Font (inactive)");
  ColorsDesc[21].color = *(DWORD*)&fMenuInact;
  strcpy(ColorsDesc[22].Name, "MenuBar: Font (active)");
  ColorsDesc[22].color = *(DWORD*)&fMenuAct;
  strcpy(ColorsDesc[23].Name, "Views: Title Font");
  ColorsDesc[23].color = *(DWORD*)&fViews;

  pD3D = CurrentState.CurrentParams.pD3D;
  sysp = CurrentState.CurrentParams.sysp;

  FontStartIndex = NumColors-3;
}

BOOL CColorPage::OnInitDialog()
{
  pColorList  = (CListBox*)GetDlgItem(IDC_COLORLIST);
  pSamplesList= (CListBox*)GetDlgItem(IDC_COLORLISTSAMPLES);
  pFontButton  = (CButton*)GetDlgItem(IDC_COLORFONTBUTTON);
  pColrButton = (CButton*)GetDlgItem(IDC_COLORCOLORBUTTON);

  CWnd*  pwnd = GetDlgItem(IDC_COLORRECT);
  pwnd->GetClientRect(&RaintRect);
  ColorSampleBar.Create(NULL,
    WS_CHILD | WS_VISIBLE | WS_CLIPCHILDREN | WS_CLIPSIBLINGS,
    RaintRect, pwnd);
  ColorSampleBar.SetProperties(RaintRect, 255,255,255);
  
  for (int i = 0; i < NumColors; i++)
  {
    pColorList->AddString(ColorsDesc[i].Name);
  }

  int amount = 0;
  if (CurrentState.IsMode(Z3D_MODE_PROGRAMMING))
  {
    pSamplesList->AddString("<Default>");pSamplesList->SetItemData(amount++, 0xFFFFFF);
    pSamplesList->AddString("<CUSTOM...>");pSamplesList->SetItemData(amount++, 0xFFFFFF);
    pSamplesList->AddString("BACKGROUND");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BACKGROUND));
    pSamplesList->AddString("ACTIVECAPTION");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_ACTIVECAPTION));
    pSamplesList->AddString("INACTIVECAPTION");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INACTIVECAPTION));
    pSamplesList->AddString("MENU");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_MENU));
    pSamplesList->AddString("WINDOW");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_WINDOW));
    pSamplesList->AddString("WINDOWFRAME");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_WINDOWFRAME));
    pSamplesList->AddString("MENUTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_MENUTEXT));
    pSamplesList->AddString("WINDOWTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_WINDOWTEXT));
    pSamplesList->AddString("CAPTIONTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_CAPTIONTEXT));
    pSamplesList->AddString("ACTIVEBORDER");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_ACTIVEBORDER));
    pSamplesList->AddString("INACTIVEBORDER");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INACTIVEBORDER));
    pSamplesList->AddString("APPWORKSPACE");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_APPWORKSPACE));
    pSamplesList->AddString("HIGHLIGHT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_HIGHLIGHT));
    pSamplesList->AddString("HIGHLIGHTTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_HIGHLIGHTTEXT));
    pSamplesList->AddString("BTNFACE");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BTNFACE));
    pSamplesList->AddString("BTNSHADOW");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BTNSHADOW));
    pSamplesList->AddString("GRAYTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_GRAYTEXT));
    pSamplesList->AddString("INACTIVECAPTIONTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INACTIVECAPTIONTEXT));
    pSamplesList->AddString("BTNHIGHLIGHT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BTNHIGHLIGHT));
    pSamplesList->AddString("3DDKSHADOW");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_3DDKSHADOW));
    pSamplesList->AddString("3DLIGHT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_3DLIGHT));
    pSamplesList->AddString("INFOTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INFOTEXT));
    pSamplesList->AddString("INFOBK");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INFOBK));
  }
  else
  {
    pSamplesList->AddString("<Default>");pSamplesList->SetItemData(amount++, 0xFFFFFF);
    pSamplesList->AddString("<CUSTOM...>");pSamplesList->SetItemData(amount++, 0xFFFFFF);
    pSamplesList->AddString("Desktop");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BACKGROUND));
    pSamplesList->AddString("Active caption");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_ACTIVECAPTION));
    pSamplesList->AddString("Inactive caption");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INACTIVECAPTION));
    pSamplesList->AddString("Menu");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_MENU));
    pSamplesList->AddString("Window");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_WINDOW));
    pSamplesList->AddString("Menu Text");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_MENUTEXT));
    pSamplesList->AddString("Window Text");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_WINDOWTEXT));
    pSamplesList->AddString("Caption Text");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_CAPTIONTEXT));
    pSamplesList->AddString("Workspace");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_APPWORKSPACE));
    pSamplesList->AddString("Menu selection color");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_HIGHLIGHT));
    pSamplesList->AddString("Menu selection text");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_HIGHLIGHTTEXT));
    pSamplesList->AddString("Buttons color");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BTNFACE));
    pSamplesList->AddString("Buttons shadow");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BTNSHADOW));
    pSamplesList->AddString("Buttons highlight");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_BTNHIGHLIGHT));
    pSamplesList->AddString("GRAYTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_GRAYTEXT));
    pSamplesList->AddString("INACTIVECAPTIONTEXT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INACTIVECAPTIONTEXT));
    pSamplesList->AddString("3DDKSHADOW");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_3DDKSHADOW));
    pSamplesList->AddString("3DLIGHT");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_3DLIGHT));
    pSamplesList->AddString("Tool tips Text");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INFOTEXT));
    pSamplesList->AddString("Tool tips back");pSamplesList->SetItemData(amount++, GetSysColor(COLOR_INFOBK));
  }


  CurrentState.CurrentParams.sysp(
      Z3D_REQUEST_LOCALIZE_USER_DIALOG, NULL, "ZModeler\\Settings\\Colors Page", this, NULL);
  pColorList->SetCurSel(0);
  OnSelChange();
  OnColChange();
  return TRUE;
}

CColorPage::~CColorPage()
{
//  AfxMessageBox("CColorPage::~CColorPage()");
  delete (LOGFONT*)ColorsDesc[21].color;
  delete (LOGFONT*)ColorsDesc[22].color;
  delete (LOGFONT*)ColorsDesc[23].color;

  if (ColorsDesc) delete[] ColorsDesc;
//  AfxMessageBox("CColorPage::~CColorPage() - DONE");
}

afx_msg void CColorPage::OnSelChange()
{
  if (pColorList->GetCurSel() >= FontStartIndex)
  {
    pSamplesList->EnableWindow(FALSE);
    pFontButton->EnableWindow(TRUE);
    pColrButton->EnableWindow(FALSE);
  }
  else
  {
    pSamplesList->EnableWindow(TRUE);
    pFontButton->EnableWindow(FALSE);
    pColrButton->EnableWindow(FALSE);
    COLORREF col = ColorsDesc[pColorList->GetCurSel()].color;//pColorList->GetItemData(pColorList->GetCurSel());
    ColorSampleBar.SetColor((BYTE)(col & 0xff), (BYTE)((col & 0xff00)>>8), (BYTE)((col & 0xff0000)>>16));
    pSamplesList->SetItemData(0, col);//dafault color;
    pSamplesList->SetItemData(1, col);//dafault color;
    pSamplesList->SetCurSel(0);
  }
}

afx_msg void CColorPage::OnColChange()
{
  COLORREF col = pSamplesList->GetItemData(pSamplesList->GetCurSel());
  ColorSampleBar.SetColor((BYTE)(col & 0xff), (BYTE)((col & 0xff00)>>8), (BYTE)((col & 0xff0000)>>16));
  ColorsDesc[pColorList->GetCurSel()].color = col;//pColorList->SetItemData(pColorList->GetCurSel(), col);
  ((CButton*)GetDlgItem(IDC_COLORCOLORBUTTON))->EnableWindow(pSamplesList->GetCurSel() == 1);
  SetModified(TRUE);
}

afx_msg void CColorPage::OnChooseColor()
{
  COLORREF col = pSamplesList->GetItemData(pSamplesList->GetCurSel());
  CColorDialog cdiag(col, CC_RGBINIT | CC_FULLOPEN, this);
  if (cdiag.DoModal()==IDOK)
  {
    col = cdiag.GetColor();
    pSamplesList->SetItemData(pSamplesList->GetCurSel(), col);
    ColorsDesc[pColorList->GetCurSel()].color = col;
    ColorSampleBar.SetColor((BYTE)(col & 0xff), (BYTE)((col & 0xff00)>>8), (BYTE)((col & 0xff0000)>>16));
    SetModified(TRUE);
  }
}

afx_msg void CColorPage::OnChooseFont()
{
  //get/set font here
  LOGFONT* pTemplate = (LOGFONT*)ColorsDesc[pColorList->GetCurSel()].color;

  CFontDialog  diag(pTemplate, CF_SCREENFONTS | /*CF_ENABLETEMPLATE | CF_USESTYLE |*/ CF_EFFECTS);
  if (diag.DoModal()==IDOK)
  {
    diag.GetCurrentFont((LOGFONT*)ColorsDesc[pColorList->GetCurSel()].color);
    SetModified(TRUE);
  }
}

BOOL CColorPage::OnApply()
{
  LOGPEN    lPen;
  LOGBRUSH  lBrush;
  int menuitemsh = 0;

  Global.PenThinBlack->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[0].color;
  Global.ColBlack = lPen.lopnColor;
  Global.PenThinBlack->DeleteObject();
  Global.PenThinBlack->CreatePenIndirect(&lPen);
  Global.PenThinBlue->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[1].color;
  Global.ColBlue = lPen.lopnColor;
  Global.PenThinBlue->DeleteObject();
  Global.PenThinBlue->CreatePenIndirect(&lPen);
  Global.PenThinGreen->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[2].color;
  Global.ColGreen = lPen.lopnColor;
  Global.PenThinGreen->DeleteObject();
  Global.PenThinGreen->CreatePenIndirect(&lPen);
  Global.PenThinDarkRed->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[3].color;
  Global.ColDarkRed = lPen.lopnColor;
  Global.PenThinDarkRed->DeleteObject();
  Global.PenThinDarkRed->CreatePenIndirect(&lPen);
  Global.PenThinRed->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[4].color;
  Global.ColRed = lPen.lopnColor;
  Global.PenThinRed->DeleteObject();
  Global.PenThinRed->CreatePenIndirect(&lPen);
  Global.PenThinGray->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[5].color;
  Global.ColGray = lPen.lopnColor;
  Global.PenThinGray->DeleteObject();
  Global.PenThinGray->CreatePenIndirect(&lPen);
  Global.ColDots = ColorsDesc[6].color;

  Global.PenThinWhite->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[7].color;
  Global.ColWhite = lPen.lopnColor;
  Global.PenThinWhite->DeleteObject();
  Global.PenThinWhite->CreatePenIndirect(&lPen);
  Global.PenThinBlueCreate->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[8].color;
  Global.PenThinBlueCreate->DeleteObject();
  Global.PenThinBlueCreate->CreatePenIndirect(&lPen);

  Global.MenuHighlightPen->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[9].color;
  Global.MenuHighlight = ColorsDesc[9].color;
  Global.MenuHighlightPen->DeleteObject();
  Global.MenuHighlightPen->CreatePenIndirect(&lPen);

  Global.MenuShadowPen->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[10].color;
  Global.MenuShadow = ColorsDesc[10].color;
  Global.MenuShadowPen->DeleteObject();
  Global.MenuShadowPen->CreatePenIndirect(&lPen);

  Global.MenuForegroundBrush->GetLogBrush(&lBrush); lBrush.lbColor = ColorsDesc[11].color;
  Global.MenuForegroundColor = ColorsDesc[11].color;
  Global.MenuForegroundBrush->DeleteObject();
  Global.MenuForegroundBrush->CreateBrushIndirect(&lBrush);
  Global.MenuActiveForegroundBrush->GetLogBrush(&lBrush); lBrush.lbColor = ColorsDesc[12].color;
  Global.MenuActiveForegroundColor = ColorsDesc[12].color;
  Global.MenuActiveForegroundBrush->DeleteObject();
  Global.MenuActiveForegroundBrush->CreateBrushIndirect(&lBrush);
  Global.MenuCaptionColor = ColorsDesc[13].color;
  Global.MenuActiveColor = ColorsDesc[14].color;
  Global.BackgroundBrush->GetLogBrush(&lBrush); lBrush.lbColor = ColorsDesc[15].color;
  Global.ViewsBackground = ColorsDesc[15].color;
  Global.BackgroundBrush->DeleteObject();
  Global.BackgroundBrush->CreateBrushIndirect(&lBrush);
  Global.GridNormalPen->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[16].color;
  Global.GridNormalColor = ColorsDesc[16].color;
  Global.GridNormalPen->DeleteObject();
  Global.GridNormalPen->CreatePenIndirect(&lPen);
  Global.GridTenthsPen->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[17].color;
  Global.GridTenthsColor = ColorsDesc[17].color;
  Global.GridTenthsPen->DeleteObject();
  Global.GridTenthsPen->CreatePenIndirect(&lPen);
  Global.GridAxisPen->GetLogPen(&lPen); lPen.lopnColor = ColorsDesc[18].color;
  Global.GridAxisColor = ColorsDesc[18].color;
  Global.GridAxisPen->DeleteObject();
  Global.GridAxisPen->CreatePenIndirect(&lPen);

  Global.ViewsCaptionColor = ColorsDesc[19].color;
  Global.ViewsActiveCaptionColor = ColorsDesc[20].color;

  LOGFONT* plfont;
  plfont = (LOGFONT*)ColorsDesc[21].color;
  Global.MenuCaptionFont->DeleteObject();
  Global.MenuCaptionFont->CreateFontIndirect(plfont);
  if (plfont->lfHeight != 0)
    menuitemsh = (BYTE)(abs(plfont->lfHeight)*0.75);
  plfont = (LOGFONT*)ColorsDesc[22].color;
  Global.MenuActiveCaptionFont->DeleteObject();
  Global.MenuActiveCaptionFont->CreateFontIndirect(plfont);
  plfont = (LOGFONT*)ColorsDesc[23].color;
  Global.ViewsCaptionFont->DeleteObject();
  Global.ViewsCaptionFont->CreateFontIndirect(plfont);
  if (menuitemsh == 0)
    menuitemsh = 8;
  Global.MenuFontHeight = menuitemsh;

  long request = Z3D_PLUGRESULT_REDRAW;
  CurrentState.CurrentParams.sysp(Z3D_REQUEST_UPDATEMENT, NULL, NULL, &request, NULL);

  return TRUE;
}